package com.elitescloud.cloudt.system.common;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 18:52
 * @Description:
 */

@Data
@ConfigurationProperties(prefix = InfinityWebProperties.INFINITY_WEB_CONFIG_PREFIX)
public class InfinityWebProperties implements InitializingBean {

    public static final String INFINITY_WEB_CONFIG_PREFIX = "cbpl.infinity.web";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("响应超时（以毫秒为单位）")
    private int responseTimeout = 3000;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("连接超时（以毫秒为单位）")
    private int connectTimeout = 3000;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("套接字读取超时（以毫秒为单位）")
    private int readTimeout = 5000;

    /**
     * 超时值为0，指无限时
     */
    @ApiModelProperty("套接字写入超时（以毫秒为单位）")
    private int writeTimeout = 5000;
    //尝试忽略证书验证（仅用于测试环境）【生产环境中是不安全的】
    private boolean isIgnoreSslSecure=false;
   //// 设置缓冲区大小，单位，字节(B) => MB 转 B
    private int maxInMemorySize=80;

    @ApiModelProperty("重试机制")
    private RetryProperty retry = new RetryProperty();

    @Data
    public static class RetryProperty {
        @ApiModelProperty("失败重试次数")
        private int retryTimes = 0;
    }

    public static boolean INFINITY_WEB_ENABLED;
    public static int RESPONSE_TIMEOUT;
    public static int CONNECT_TIMEOUT;
    public static int READ_TIMEOUT;
    public static int WRITE_TIMEOUT;
    public static int RETRY_TIMES;

    @Override
    public void afterPropertiesSet() throws Exception {
        INFINITY_WEB_ENABLED = enabled;
        RESPONSE_TIMEOUT = responseTimeout;
        CONNECT_TIMEOUT = connectTimeout;
        READ_TIMEOUT = readTimeout;
        WRITE_TIMEOUT = writeTimeout;
        RETRY_TIMES = retry.getRetryTimes();
    }
}
