package com.elitescloud.cloudt.system.common;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:21
 * @Description:
 */
@ConfigurationProperties(
        prefix = "cbpl.sns.bot"
)
public class SnsBotProperties implements InitializingBean {

    public static final String BOT_CONFIG_PREFIX = "cbpl.sns.bot";
    private boolean enabled;
    public static boolean SNS_BOT_ENABLED;

    public void afterPropertiesSet() throws Exception {
        SNS_BOT_ENABLED = this.enabled;
    }

    public SnsBotProperties() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof SnsBotProperties)) {
            return false;
        } else {
            SnsBotProperties other = (SnsBotProperties) o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                return this.isEnabled() == other.isEnabled();
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof SnsBotProperties;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SnsBotProperties(enabled=" + this.isEnabled() + ")";
    }
}
