package com.elitescloud.cloudt.system.config.support;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/15
 */
public class SystemPlatformAppProvider implements PlatformAppProvider {

    private final SysPlatformAppService appService;

    public SystemPlatformAppProvider(SysPlatformAppService appService) {
        this.appService = appService;
    }

    @Override
    public List<CodeNameParam> all() {
        var appList = appService.all().getData();
        if (CollectionUtils.isEmpty(appList)) {
            return Collections.emptyList();
        }
        return appList.stream().map(t -> new CodeNameParam(t.getCode(), t.getName())).collect(Collectors.toList());
    }
}
