package com.elitescloud.cloudt.system.controller.mng.businessobject;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessObjectPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.QueryBusinessOperationParam;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.*;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessObjectSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessOperationSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.UpdateFieldPermissionFilterParam;
import com.elitescloud.cloudt.system.service.BusinessObjectMngService;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/8
 */
@Api(tags = "业务对象管理")
@RestController
@RequestMapping(value = "/mng/businessObject", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class BusinessObjectMngController {

    private BusinessObjectMngService service;


    @ApiOperation(value = "查询业务对象操作操作的参数")
    @PostMapping(value = "/businessOperationParam/queryByOpenApiCode")
    public ApiResult<List<BusinessOperationParamBO>> queryBusinessOperationParam(
            @RequestBody QueryBusinessOperationParam queryBusinessOperationParam){
        var paramBOList = service.queryBusinessOperationParam(queryBusinessOperationParam.getOpenApiCode(),
                queryBusinessOperationParam.getParamInEnum());
        return paramBOList;
    }

    @ApiOperation(value = "修改业务对象操作参数 是否权限过滤")
    @PutMapping(value = "/businessOperationParam/updateFieldPermissionFilter")
    public ApiResult<Boolean> updateFieldPermissionFilter(
            @RequestBody UpdateFieldPermissionFilterParam param){
        return  service.updateBusinessOperationFieldPermissionFilter(param);
    }

    @ApiOperation(value = "【测试】测试OpenApi转BusinessObject")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "openApiId", value = "openApiId"),
            @ApiImplicitParam(name = "openApiOperationId", value = "操作ID"),
            @ApiImplicitParam(name = "save", value = "是否保存"),
    })
    @GetMapping(value = "/testAnalyze")
    public ApiResult<Boolean> testAnalyze(@RequestParam(name = "openApiId") Long openApiId,
                                          @RequestParam(name = "openApiOperationId", required = false) Long openApiOperationId,
                                          @RequestParam(name = "save", required = false, defaultValue = "false") Boolean save) throws Exception {
        return service.testAnalyzeOpenApi(openApiId, openApiOperationId, save);
    }

    @ApiOperation(value = "根据OpenApiId生成")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParam(name = "openApiId", value = "openApiId", required = true)
    @PostMapping(value = "/generateByOpenApi")
    public ApiResult<Long> generateByOpenApi(@RequestParam(name = "openApiId") @NotNull(message = "OpenApiId") Long openApiId) {
        return service.generateByOpenApi(openApiId);
    }

    @ApiOperation(value = "分页查询业务对象")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/pageBusinessObject")
    public ApiResult<PagingVO<BusinessObjectPageRespVO>> pageMng(@RequestBody BusinessObjectPageQueryVO queryVO) {
        return service.pageObject(queryVO);
    }

    @ApiOperation(value = "保存业务对象信息")
    @ApiOperationSupport(order = 4)
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid BusinessObjectSaveVO saveVO) {
        return service.saveBusinessObject(saveVO);
    }

    @ApiOperation(value = "获取业务对象信息")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParam(name = "id", value = "业务对象ID", required = true, dataType = "long")
    @GetMapping(value = "/detail")
    public ApiResult<BusinessObjectDetailRespVO> getDetail(@RequestParam(name = "id") @NotNull(message = "ID为空") Long id) {
        return service.getDetail(id);
    }

    @ApiOperation(value = "获取业务操作信息")
    @ApiOperationSupport(order = 11)
    @ApiImplicitParam(name = "operationId", value = "业务对象的操作ID", required = true, dataType = "long")
    @GetMapping(value = "/operation")
    public ApiResult<BusinessOperationRespVO> getBusinessOperation(@RequestParam(name = "operationId") @NotNull(message = "操作ID为空") Long operationId) {
        return service.getBusinessOperation(operationId);
    }

    @ApiOperation(value = "分页查询业务操作")
    @ApiOperationSupport(order = 12)
    @PostMapping(value = "/pageBusinessOperation")
    public ApiResult<PagingVO<BusinessOperationPageRespVO>> pageMng(@RequestBody BusinessOperationPageQueryVO queryVO) {
        return service.pageOperation(queryVO);
    }

    @ApiOperation(value = "保存业务操作信息")
    @ApiOperationSupport(order = 13)
    @PostMapping(value = "/operation/save")
    public ApiResult<Long> save(@RequestBody @Valid BusinessOperationSaveVO saveVO) {
        return service.saveBusinessOperation(saveVO);
    }

    @ApiOperation(value = "批量保存业务操作信息")
    @ApiOperationSupport(order = 13)
    @PostMapping(value = "/operation/save/batch")
    public ApiResult<Set<Long>> save(@RequestBody @Valid List<BusinessOperationSaveVO> saveVO) {
        return service.saveBusinessOperation(saveVO);
    }

    @ApiOperation(value = "获取业务对象的权限字段")
    @ApiOperationSupport(order = 21)
    @ApiImplicitParam(name = "id", value = "业务对象ID", required = true, dataType = "long")
    @GetMapping(value = "/permissionField")
    public ApiResult<List<BusinessPermissionParamRespVO>> getPermissionField(@RequestParam(name = "id") @NotNull(message = "业务对象ID为空") Long id) {
        return service.listPermissionFields(id);
    }

    @ApiOperation(value = "获取业务操作的权限字段")
    @ApiOperationSupport(order = 22)
    @ApiImplicitParam(name = "operationId", value = "业务对象的操作ID", required = true, dataType = "long")
    @GetMapping(value = "/operation/permissionField")
    public ApiResult<List<BusinessPermissionParamRespVO>> getOperationPermissionField(@RequestParam(name = "operationId") @NotNull(message = "操作ID为空") Long operationId) {
        return service.listOperationPermissionFields(operationId);
    }

    @ApiOperation(value = "修改权限字段的是否支持数据权限")
    @ApiOperationSupport(order = 31)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "paramId", value = "业务参数ID", required = true, dataType = "long"),
            @ApiImplicitParam(name = "enabled", value = "是否启用", dataType = "boolean"),
    })
    @PatchMapping(value = "/param/dataPermission")
    public ApiResult<Long> updateParamDataPermission(@RequestParam(name = "paramId") @NotNull(message = "参数ID为空") Long paramId,
                                                     @RequestParam(name = "enabled", required = false, defaultValue = "false") Boolean enabled) {
        return service.updateDataPermissionEnabledOfParam(paramId, enabled);
    }

    @ApiOperation(value = "修改权限字段的是否支持字段权限")
    @ApiOperationSupport(order = 33)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "paramId", value = "业务参数ID", required = true, dataType = "long"),
            @ApiImplicitParam(name = "enabled", value = "是否启用", dataType = "boolean"),
    })
    @PatchMapping(value = "/param/fieldPermission")
    public ApiResult<Long> updateParamFieldPermission(@RequestParam(name = "paramId") @NotNull(message = "参数ID为空") Long paramId,
                                                      @RequestParam(name = "enabled", required = false, defaultValue = "false") Boolean enabled) {
        return service.updateFieldPermissionEnabledOfParam(paramId, enabled);
    }

    @Autowired
    public void setService(BusinessObjectMngService service) {
        this.service = service;
    }
}
