package com.elitescloud.cloudt.system.controller.mng.callback;

import com.elitescloud.boot.util.JSONUtil;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/28
 */
@Api(tags = "工作流回调")
@RestController
@RequestMapping(value = WorkflowConstant.WORKFLOW + "WANGS_T" + "/callBack", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class WorkflowCallbackController implements WorkflowCallBack {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowCallbackController.class);

    @PostMapping(value = WorkflowConstant.TASK_ASSIGNEE_PATH)
    @Override
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        logger.info("执行人获取回调：{}", JSONUtil.toJsonString(payload));
        return WorkflowResult.success(new ArrayList<>(0));
    }

    @PostMapping(value = WorkflowConstant.TASK_CREATED_PATH)
    @Override
    public WorkflowResult<Void> taskCreated(TaskCreatedPayload payload) {
        logger.info("任务创建回调：{}", JSONUtil.toJsonString(payload));
        return WorkflowResult.success(null);
    }

    @PostMapping(value = WorkflowConstant.TASK_COMPLETED_PATH)
    @Override
    public WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload) {
        logger.info("任务完成回调：{}", JSONUtil.toJsonString(payload));
        return WorkflowResult.success(null);
    }

    @PostMapping(value = WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    @Override
    public WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload) {
        logger.info("流程状态变化回调：{}", JSONUtil.toJsonString(payload));
        return WorkflowResult.success(null);
    }
}
