package com.elitescloud.cloudt.system.controller.mng.datarelation;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationInstEditQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationConfigRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationInstEditRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationInstSaveVO;
import com.elitescloud.cloudt.system.service.DataRelationInstMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/15
 */
@Api(tags = "数据关系配置")
@RestController
@RequestMapping(value = "/mng/boDataInst", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class DataRelationInstMngController {
    private DataRelationInstMngService service;

    @ApiOperation(value = "获取数据关系配置")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParam(name = "drCode", value = "数据关系编码", required = true)
    @GetMapping(value = "/config")
    public ApiResult<DataRelationConfigRespVO> getConfig(@NotBlank(message = "数据关系编码为空") String drCode) {
        return service.getConfig(drCode);
    }

    @ApiOperation(value = "保存配置的值")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/value/save")
    public ApiResult<Boolean> saveValues(@RequestBody @Valid DataRelationInstSaveVO saveVO) {
        return service.saveValues(saveVO);
    }

    @ApiOperation(value = "获取已配置的值")
    @ApiOperationSupport(order = 3)
    @PostMapping(value = "/value/get")
    public ApiResult<DataRelationInstEditRespVO> getValues(@RequestBody @Valid DataRelationInstEditQueryVO queryVO) {
        return service.getValues(queryVO);
    }

    @Autowired
    public void setService(DataRelationInstMngService service) {
        this.service = service;
    }
}
