package com.elitescloud.cloudt.system.controller.mng.datarelation;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationSaveVO;
import com.elitescloud.cloudt.system.service.DataRelationMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 数据关系管理.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Api(tags = "数据关系管理")
@RestController
@RequestMapping(value = "/mng/boData", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class DataRelationMngController {

    private DataRelationMngService service;

    @ApiOperation(value = "分页查询数据关系")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<DataRelationPagedRespVO>> page(@RequestBody DataRelationPageQueryVO queryVO) {
        return service.page(queryVO);
    }

    @ApiOperation(value = "保存数据关系")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/save")
    public ApiResult<Long> save(@RequestBody @Valid DataRelationSaveVO saveVO) {
        return service.save(saveVO);
    }

    @ApiOperation(value = "根据ID获取数据关系")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "long")
    @GetMapping(value = "/get")
    public ApiResult<DataRelationEditRespVO> get(@RequestParam(name = "id") @NotNull(message = "ID为空") Long id) {
        return service.get(id);
    }

    @ApiOperation(value = "根据ID批量删除数据关系")
    @ApiOperationSupport(order = 4)
    @PostMapping(value = "/deleteBatch")
    public ApiResult<List<Long>> delete(@RequestBody @NotEmpty(message = "ID为空") List<Long> ids) {
        return service.delete(ids);
    }

    @ApiOperation(value = "修改数据关系的状态")
    @ApiOperationSupport(order = 5)
    @PatchMapping(value = "/enabled")
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        return service.updateEnabled(id, enabled);
    }

    @Autowired
    public void setService(DataRelationMngService service) {
        this.service = service;
    }
}
