package com.elitescloud.cloudt.system.controller.mng.user;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.user.sync.UserSyncRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.sync.UserSyncRecordDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.save.user.sync.JdeUserSaveVO;
import com.elitescloud.cloudt.system.provider.usersync.jde.JdeUserSyncProvider;
import com.elitescloud.cloudt.system.service.UserSyncMngService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/30
 */
@Api(tags = "账号同步")
@RestController
@RequestMapping(value = "/mng/userSync", produces = MediaType.APPLICATION_JSON_VALUE)
@Validated
public class UserSyncMngController {

    private UserSyncMngService mngService;

    @ApiOperation(value = "分页查询同步信息")
    @ApiOperationSupport(order = 1)
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<UserSyncRecordDetailRespVO>> pageQuery(@RequestBody UserSyncRecordPageQueryVO queryVO) {
        return mngService.pageQuery(queryVO);
    }

    @ApiOperation(value = "同步JDE账户")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/jde/syncUser")
    public ApiResult<Long> syncJdeUser(@RequestBody @Valid JdeUserSaveVO saveVO) {
        return mngService.syncUser(JdeUserSyncProvider.CODE, saveVO.getId(), saveVO);
    }

    @ApiOperation(value = "查看指定账号的同步记录")
    @ApiOperationSupport(order = 3)
    @ApiImplicitParam(name = "id", value = "账户ID", required = true, dataType = "long")
    @PostMapping(value = "/user/record")
    public ApiResult<List<UserSyncRecordDetailRespVO>> listSyncRecord(@RequestParam(name = "id") @NotNull(message = "账户ID为空") Long id) {
        return mngService.listSyncRecord(JdeUserSyncProvider.CODE, id);
    }

    @Autowired
    public void setMngService(UserSyncMngService mngService) {
        this.mngService = mngService;
    }
}
