package com.elitescloud.cloudt.system.convert;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.model.entity.InfinityFolderDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BasicAuthAccountVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FolderSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.OAuth2AccountVO;
import com.elitescloud.cloudt.system.util.BeanUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

import java.util.List;

import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_BASIC_AUTH;
import static com.elitescloud.cloudt.system.common.AuthMethod.AUTH_METHOD_OAUTH_V2;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 17:15
 * @Description:
 */
@Mapper(config = BaseMapperConfig.class)
public interface InfinityFolderConvert {

    InfinityFolderConvert INSTANCE = Mappers.getMapper(InfinityFolderConvert.class);

    /**
     * SaveParam => DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    InfinityFolderDO saveParamToDO(FolderSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    @Mapping(target = "authAccount", expression = "java(authAccountToStr(saveParam))")
    void saveParamMergeToDO(FolderSaveParamVO saveParam, @MappingTarget InfinityFolderDO infinityFolderDO);

    /**
     * FolderDO => ApiVO
     */
    List<InfinityApiRespVO> toApiFolder(List<InfinityFolderDO> folderRespVOS);

    /**
     * FolderDO => ApiVO
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "platformCode", ignore = true)
    @Mapping(target = "remark", ignore = true)
    @Mapping(target = "folderId", source = "id")
    @Mapping(target = "basicAuthAccount", expression = "java(toBasicAuthAccount(folderRespVO))")
    @Mapping(target = "oauth2Account", expression = "java(toOAuthAccount(folderRespVO))")
    InfinityApiRespVO toApiFolder(InfinityFolderDO folderRespVO);

    @Named("authAccountToStr")
    default String authAccountToStr(FolderSaveParamVO saveParam) {
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            BasicAuthAccountVO account = saveParam.getBasicAuthAccount();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        if (saveParam.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            OAuth2AccountVO account = saveParam.getOauth2Account();
            if (ObjectUtil.isNull(account) || account.isEmpty()) {
                throw new RuntimeException("account is empty.");
            }
            return BeanUtils.toJsonStr(account);
        }
        return "";
    }

    @Named("toBasicAuthAccount")
    default BasicAuthAccountVO toBasicAuthAccount(InfinityFolderDO folderRespVO) {
        if (StrUtil.isBlank(folderRespVO.getAuthAccount())) {
            return null;
        }
        if (folderRespVO.getAuthMethod().equals(AUTH_METHOD_BASIC_AUTH.getCode())) {
            return BeanUtils.toBean(folderRespVO.getAuthAccount(), BasicAuthAccountVO.class);
        }
        return null;
    }

    @Named("toOAuthAccount")
    default OAuth2AccountVO toOAuthAccount(InfinityFolderDO folderRespVO) {
        if (StrUtil.isBlank(folderRespVO.getAuthAccount())) {
            return null;
        }
        if (folderRespVO.getAuthMethod().equals(AUTH_METHOD_OAUTH_V2.getCode())) {
            return BeanUtils.toBean(folderRespVO.getAuthAccount(), OAuth2AccountVO.class);
        }
        return null;
    }
}
