package com.elitescloud.cloudt.system.model.bo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.cloudt.system.config.SystemProperties;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 业务对象简单信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/26
 */
@Getter
@Setter
public class BusinessObjectBO implements Serializable {
    private static final long serialVersionUID = -4224373593772230932L;

    /**
     * ID
     */
    private Long id;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 业务对象的编码
     */
    private String code;

    /**
     * 业务对象的名称
     */
    private String name;

    /**
     * 自定义名称
     */
    private String customName;

    /**
     * 业务对象的描述
     */
    private String description;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否是公共资源
     */
    private Boolean publicResource;

    /**
     * 实体类名称
     */
    private String entityClassName;

    public String detectName() {
        if (StringUtils.hasText(customName)) {
            return customName;
        }
        return name;
    }

    public Boolean getPublicResource() {
        if (Boolean.TRUE.equals(publicResource)) {
            return true;
        }
        var resources = SpringContextHolder.getBean(SystemProperties.class).getBusinessObjectPublicResources();
        return CollUtil.isNotEmpty(resources) && resources.contains(code);
    }
}
