package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

/**
 * 业务对象.
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/7
 */
@Getter
@Setter
public class BusinessObjectConvertBO {

    /**
     * OpenApi的编码
     */
    private String openApiCode;

    /**
     * 应用编码
     */
    private String appCode;

    /**
     * 业务对象的编码
     */
    private String code;

    /**
     * 业务对象的名称
     */
    private String name;

    /**
     * 业务对象的描述
     */
    private String description;

    /**
     * entity类的名称
     */
    private String entityClassName;

    /**
     * 领域分类
     */
    private String domain;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 关联的操作
     */
    private String[] refBusinessObjectOperations;

    /**
     * 是否是公共资源
     */
    private Boolean publicResource;

    /**
     * 是否支持租户
     */
    private Boolean supportTenant;

    /**
     * 业务对象参数
     */
    private Map<String, BusinessParam> businessParamMap;

    /**
     * 操作列表
     */
    private Map<String, Operation> operationMap;

    /**
     * 业务对象参数
     */
    @Getter
    @Setter
    public static class BusinessParam {
        /**
         * OpenApi的编码
         */
        private String openApiCode;

        /**
         * 业务对象编码
         */
        private String businessObjectCode;

        /**
         * entity类的名称
         */
        private String entityClassName;

        /**
         * 表名
         */
        private String tableName;

        /**
         * 字段名称
         */
        private String fieldName;

        /**
         * 列名称
         */
        private String columnName;

        /**
         * 字段描述
         */
        private String fieldDescription;

        /**
         * 字段类型(java)
         */
        private String fieldJavaType;

        /**
         * 是否为子表
         */
        private boolean sub;

        /**
         * 与主表关联的字段
         */
        private String relatedMasField;

        /**
         * 关联的主表中的字段
         */
        private String masField;

        /**
         * 是否为单值
         */
        private Boolean single;

        /**
         * 是否枚举类
         */
        private Boolean enumeration;

        /**
         * 枚举值类型
         */
        private String enumType;

        /**
         * 关联业务对象标识
         */
        private String relatedBusinessObject;

        /**
         * 关联业务对象字段
         */
        private String relatedField;

        /**
         * 值
         */
        private String[] values;

        /**
         * 账户类型
         */
        private String userType;

        /**
         * 是否应于数据权限过滤
         */
        private Boolean dataPermissionEnabled;

        /**
         * 是否应于字段权限过滤
         */
        private Boolean fieldPermissionEnabled;

        /**
         * 是否为基础字段
         */
        private Boolean baseField;

        /**
         * 是否过期
         */
        private Boolean deprecated;
    }

    /**
     * 业务操作
     */
    @Getter
    @Setter
    public static class Operation {
        /**
         * OpenApi的编码
         */
        private String openApiCode;
        /**
         * 业务对象编码
         */
        private String businessObjectCode;
        /**
         * 应用编码
         */
        private String appCode;
        /**
         * 操作编码
         */
        private String operationCode;

        /**
         * 操作名称
         */
        private String operationDescription;

        /**
         * 操作描述
         */
        private String detail;

        /**
         * 操作类型
         * <p>
         * 取值：{@link com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum}
         */
        private String operationType;

        /**
         * 是否启用数据权限
         */
        private Boolean permissionEnabled;

        /**
         * 是否自动过滤字段权限
         */
        private Boolean fieldPermissionAutoFilter;

        /**
         * 关联权限的操作编码
         */
        private String permissionRef;

        /**
         * 操作范围
         * <p>
         * 取值：{@link OperationScopeEnum}
         */
        private String scope;

        /**
         * 操作状态
         * <p>
         * 取值：{@link OperationStateEnum}
         */
        private String state;

        /**
         * 显示类型
         */
        private String displayType;

        /**
         * 显示样式
         */
        private String displayStyle;

        /**
         * 显示条件
         */
        private String displayCondition;

        /**
         * 显示图标
         */
        private String displayIcon;

        /**
         * 显示顺序
         */
        private Integer displayOrder;

        /**
         * API操作名称
         */
        private String apiName;

        /**
         * API描述
         */
        private String apiDescription;

        /**
         * API的URL
         */
        private String apiUrl;

        /**
         * API的方法
         */
        private String apiMethod;

        /**
         * 是否启用
         */
        private Boolean enabled;

        /**
         * 方法的参数列表
         */
        private List<OperationParam> paramList;
    }

    /**
     * 业务操作的参数
     */
    @Getter
    @Setter
    public static class OperationParam {
        /**
         * OpenApi的编码
         */
        private String openApiCode;

        /**
         * 业务操作编码
         */
        private String openApiOperationCode;

        /**
         * 业务对象编码
         */
        private String businessObjectCode;

        /**
         * 业务操作编码
         */
        private String businessOperationCode;

        /**
         * 字段名称
         */
        private String fieldName;

        /**
         * 字段描述
         */
        private String fieldDescription;

        /**
         * 是否是Request参数
         */
        private Boolean request;

        /**
         * 字段类型
         */
        private String fieldType;

        /**
         * 字段类型(java)
         */
        private String fieldJavaType;

        /**
         * 是否有依赖
         */
        private Boolean ref;

        /**
         * 依赖地址
         */
        private String refValue;

        /**
         * 参数深度
         */
        private Integer depth;

        /**
         * 参数路径
         */
        private String paramPath;

        /**
         * 是否是ApiResult的参数
         */
        private Boolean apiResult;

        /**
         * 是否分页PagingVO的参数
         */
        private Boolean pagingResult;

        /**
         * 字段是否可为空
         */
        private Boolean required;

        /**
         * 是否过期
         */
        private Boolean deprecated;

        /**
         * 参数类型
         * <p>
         * 取值：{@link BusinessObjectParamInEnum}
         */
        private String paramIn;

        /**
         * 是否是单值
         */
        private Boolean single;

        /**
         * 集合类型
         * <p>
         * 取值：{@link com.elitescloud.cloudt.system.service.common.constant.BusinessObjectCollectionTypeEnum}
         */
        private String collectionType;

        /**
         * 是否启用
         */
        private Boolean enabled;

        /**
         * 子字段
         */
        private List<OperationParam> itemList;
    }
}
