package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/29
 */
@Getter
@Setter
public class PermissionResBO implements Serializable {
    private static final long serialVersionUID = -1394466101023861490L;

    /**
     * 持有者类型
     */
    @NotNull
    private PermissionOwnerTypeEnum ownerTypeEnum;

    /**
     * 持有者标识
     */
    @NotBlank
    private String ownerId;

    /**
     * 资源列表
     */
    private List<Res> resList;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class Res implements Serializable {
        private static final long serialVersionUID = -1301563776294385415L;

        /**
         * 资源类型
         */
        @NotNull
        private MenuTreeNodeType resTypeEnum;

        /**
         * 资源标识
         */
        @NotBlank
        private String resId;
    }
}
