package com.elitescloud.cloudt.system.model.bo;

import lombok.Data;

import java.io.Serializable;

/**
 * 权限信息.
 *
 * @author Kaiser（wang shao）
 * 2022/4/11
 */
@Data
public class SysPermissionBO implements Serializable, Comparable<SysPermissionBO> {

    private static final long serialVersionUID = -5941535923091337436L;

    private Long id;

    /**
     * 权限代码
     */
    private String code;

    /**
     * 权限名称
     */
    private String name;

    /**
     * 权限类型
     */
    private Integer permType;

    /**
     * 父权限ID
     */
    private Long parentId;

    /**
     * 权限层级路径
     */
    private String path;

    /**
     * 权限层级
     */
    private Integer permLevel;

    /**
     * 排列顺序
     */
    private Integer sortNo = 0;

    /**
     * URL路径不能为空
     */
    private String pattern;

    /**
     * 菜单是否隐藏
     */
    private String httpMethod;

    /**
     * 菜单是否隐藏
     */
    private Boolean isHidden;

    /**
     * 图标
     */
    private String icon;

    @Override
    public int compareTo(SysPermissionBO o) {
        return sortNo - o.getSortNo();
    }
}
