package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.cloudt.system.service.common.constant.UnifyQueryTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 统一查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/11
 */
@Getter
@Setter
public class UnifyQueryParamBO implements Serializable {
    private static final long serialVersionUID = 3843333115373978648L;

    /**
     * 查询类型
     */
    @NotNull
    private UnifyQueryTypeEnum queryType;

    /**
     * 应用编码
     */
    @NotBlank
    private String appCode;

    /**
     * SQL查询
     */
    private SQL sqlQuery;

    /**
     * 业务对象查询
     */
    private BusinessObject businessObjectQuery;

    /**
     * 查询条件
     */
    private Map<String, Object> conditions;

    /**
     * 条件的字段类型
     */
    private Map<String, String> conditionFileTypes;

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class SQL implements Serializable {
        private static final long serialVersionUID = -6274161062929113318L;

        @NotBlank(message = "SQL不能为空")
        private String sql;
    }

    @Getter
    @Setter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class BusinessObject implements Serializable {
        private static final long serialVersionUID = 3699297784845003356L;

        /**
         * 查询业务对象编码
         */
        @NotBlank(message = "查询业务对象编码不能为空")
        private String businessObjectCode;

        /**
         * 查询字段
         */
        @NotEmpty(message = "查询字段不能为空")
        private List<String> queryFields;
    }
}
