package com.elitescloud.cloudt.system.model.bo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 用户组织.
 *
 * @author Kaiser（wang shao）
 * 2022/10/24
 */
@Data
public class UserOrgBO implements Serializable {
    private static final long serialVersionUID = -2313223984694709374L;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 组织列表
     */
    private List<SysOrgBasicDTO> orgList;

    /**
     * 所选组织
     */
    private SysOrgBasicDTO org;

    /**
     * 租户组织
     */
    private SysOrgBasicDTO tenantOrg;

    /**
     * 租户组织管理员ID
     */
    private Long tenantOrgAdminId;

    /**
     * 岗位信息
     */
    private IdCodeNameParam position;
}
