package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.time.LocalDateTime;

/**
 * MQ消息发送记录.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@Entity
@Table(name = "sys_mq_retry", indexes = {
        @Index(name = "idx_mq_msg_re_msgid", columnList = "messageId"),
})
@Comment("MQ消息发送记录")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
public class SysMqRetryDO extends BaseModel {
    private static final long serialVersionUID = -4674644363894126422L;

    /**
     * 消息ID
     */
    @Comment("消息ID")
    @Column()
    private String messageId;

    /**
     * 是否是消费时失败
     */
    @Comment("是否是消费失败")
    @Column()
    private Boolean consumer;

    /**
     * 发送重试的次数
     */
    @Comment(value = "发送重试的次数", defaultValue = "0")
    @Column()
    private Integer retryTimes;

    /**
     * 上次发送时间
     */
    @Comment("上次发送时间")
    @Column()
    private LocalDateTime sendTime;

    /**
     * 下次发送时间
     */
    @Comment("下次发送时间")
    @Column()
    private LocalDateTime sendTimeNext;
}
