package com.elitescloud.cloudt.system.model.entity;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/8 12:01
 */

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.List;

/**
 * 页面字段配置明细;undefined
 * @author : http://www.chiner.pro
 * @date : 2023-9-8
 */
@ApiModel(value = "页面字段配置明细",description = "undefined")
@Table(name="sys_page_field_config_dtl")
@Comment("页面字段配置明细")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
@Entity
public class SysPageFieldConfigDtlDO extends BaseModel implements Serializable,Cloneable{

    /** 所属应用 */
    @ApiModelProperty(name = "所属应用",notes = "")
    @Comment("所属应用")
    @Column()
    private String appCode ;
    /** 所属应用名称 */
    @ApiModelProperty(name = "所属应用名称",notes = "")
    @Comment("所属应用名称")
    @Column()
    private String appName ;
    /** 配置名称 */
    @ApiModelProperty(name = "配置名称",notes = "")
    @Comment("配置名称")
    @Column()
    private String configName ;
    /** 配置编码 */
    @ApiModelProperty(name = "配置编码",notes = "")
    @Comment("配置编码")
    @Column()
    private String configCode ;
    /** 字段名称 */
    @ApiModelProperty(name = "字段名称",notes = "")
    @Comment("字段名称")
    @Column()
    private String fieldName ;
    /** 字段编码 */
    @ApiModelProperty(name = "字段编码",notes = "")
    @Comment("字段编码")
    @Column()
    private String fieldCode ;
    /** 是否必填 */
    @ApiModelProperty(name = "是否必填",notes = "")
    @Comment("是否必填")
    @Column()
    private Boolean fieldRequired ;
    /** 字段别名 */
    @ApiModelProperty(name = "字段别名",notes = "")
    @Comment("字段别名")
    @Column()
    private String fieldAlias ;
    /** 行号 */
    @ApiModelProperty(name = "行号",notes = "")
    @Comment("行号")
    @Column()
    private Double linenum ;


    @ApiModelProperty(name = "字段类型", notes = "字段的数据类型，这可以用于根据数据类型执行不同的验证或格式化操作")
    private String fieldType;
    @ApiModelProperty(name = "字段类型名称", notes = "字段的数据类型，这可以用于根据数据类型执行不同的验证或格式化操作")
    private String fieldTypeName;
    @ApiModelProperty(name = "字段排序",notes = "字段在页面上的排序顺序")
    @Comment("字段排序")
    @Column()
    private Integer fieldOrder ;
    @ApiModelProperty(name = "是否隐藏",notes = "")
    @Comment("是否隐藏")
    @Column()
    private Boolean fieldHidden ;
    @ApiModelProperty(name = "是否可编辑",notes = "")
    @Comment("是否可编辑")
    @Column()
    private Boolean fieldEdit;
    @ApiModelProperty(name = "默认值展示",notes = "")
    @Comment("默认值展示")
    @Column()
    private String fieldDefaultValue ;
    @ApiModelProperty(name = "字段宽度",notes = "")
    @Comment("字段宽度")
    @Column()
    private String fieldWidth ;
    @ApiModelProperty(name = "字段帮助",notes = "字段的详细描述，以便在页面上提供更多的信息")
    @Comment("字段帮助")
    @Column()
    private String fieldDescription;
    @ApiModelProperty(name = "字段样式", notes = "字段的样式属性")
    private String fieldStyle;


//    @ApiModelProperty(name = "字段表单类型", notes = "表单中字段使用的类型，如：下拉框，文本框，多选框，前端组件，")
//    private String fieldFromType;
//    @ApiModelProperty(name = "字段组件类型", notes = "表单中字段是前端组件类型中具体那个前端组件，如：UDC组件，客户下拉选择组件")
//    private String fieldFromModuleType;
//    @ApiModelProperty(name = "字段表单分组", notes = "字段表单分组,已经的可以展示在一起")
//    private String fieldFromGroup;
//    @ApiModelProperty(name = "验证规则", notes = "字段需要特定的验证规则，例如正则表达式验证、最小/最大长度验证等，")
//    private String validationRule;

//    @ApiModelProperty(name = "关联字段", notes = "与该字段关联的其他字段")
//    private List<String> relatedField;
//    @ApiModelProperty(name = "字段选项", notes = "字段的选项列表")
//    private List<String> fieldOptions;
//@ApiModelProperty(name = "字段权限", notes = "字段的可见性和编辑权限")
//private List<String> fieldPermissions;
}
