package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author : chen.niu
 * @description :岗位
 * @date : 2024-05-13 16:05
 */
@ApiModel(value = "岗位",description = "岗位")
@Comment("岗位")
@DynamicUpdate
@DynamicInsert
@Getter
@Setter
@Accessors(chain = true)
@Table(name="sys_position")
@Entity
public class SysPositionDO extends BaseModel {

    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String positionCode;
    @Column(nullable = false)
    @BusinessParam(dataPermissionEnabled = true, fieldPermissionEnabled = true)
    private String positionName;
    @Column()
    private String positionDescription;
}
