package com.elitescloud.cloudt.system.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "sys_version")
@Comment("系统版本")
@Getter
@Setter
public class SysVersionDO extends BaseModel {
    private static final long serialVersionUID = 1759102369168364339L;

    @Column()
    @Comment("版本号")
    private String versionNo;

    @Column()
    @Comment("版本描述")
    private String describeMsg;

    @Column()
    @Comment("发布时间")
    private LocalDateTime releaseTime;

    @Column()
    @Comment("变更日志")
    private String changeContent;

    @Column()
    @Comment(value = "生效状态",defaultValue = "0")
    private Boolean status;
}