package com.elitescloud.cloudt.system.model.vo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.system.util.BeanUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 19:17
 * @Description:
 */
@ApiModel("机器人通知参数")
public class BotRequest {
    @ApiModelProperty("消息编码")
    private String snsCode;
    @ApiModelProperty("消息标题")
    private String snsTitle;
    @ApiModelProperty("消息模式")
    private String snsMode;
    @ApiModelProperty("消息类型")
    private String snsType;
    @ApiModelProperty("消息场景")
    private String snsScene;
    @ApiModelProperty("自定义扩展对象")
    private Object extObj;
    @ApiModelProperty("消息内容")
    private List<BotMessage> messages;

    public <T> T resolveExtObj(Class<T> clazz) {
        return ObjectUtil.isNull(this.extObj) ? null : BeanUtils.toBean(this.extObj, clazz);
    }

    public BotRequest() {
    }

    public String getSnsCode() {
        return this.snsCode;
    }

    public String getSnsTitle() {
        return this.snsTitle;
    }

    public String getSnsMode() {
        return this.snsMode;
    }

    public String getSnsType() {
        return this.snsType;
    }

    public String getSnsScene() {
        return this.snsScene;
    }

    public Object getExtObj() {
        return this.extObj;
    }

    public List<BotMessage> getMessages() {
        return this.messages;
    }

    public void setSnsCode(final String snsCode) {
        this.snsCode = snsCode;
    }

    public void setSnsTitle(final String snsTitle) {
        this.snsTitle = snsTitle;
    }

    public void setSnsMode(final String snsMode) {
        this.snsMode = snsMode;
    }

    public void setSnsType(final String snsType) {
        this.snsType = snsType;
    }

    public void setSnsScene(final String snsScene) {
        this.snsScene = snsScene;
    }

    public void setExtObj(final Object extObj) {
        this.extObj = extObj;
    }

    public void setMessages(final List<BotMessage> messages) {
        this.messages = messages;
    }

    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof BotRequest)) {
            return false;
        } else {
            BotRequest other = (BotRequest) o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                label95:
                {
                    Object this$snsCode = this.getSnsCode();
                    Object other$snsCode = other.getSnsCode();
                    if (this$snsCode == null) {
                        if (other$snsCode == null) {
                            break label95;
                        }
                    } else if (this$snsCode.equals(other$snsCode)) {
                        break label95;
                    }

                    return false;
                }

                Object this$snsTitle = this.getSnsTitle();
                Object other$snsTitle = other.getSnsTitle();
                if (this$snsTitle == null) {
                    if (other$snsTitle != null) {
                        return false;
                    }
                } else if (!this$snsTitle.equals(other$snsTitle)) {
                    return false;
                }

                Object this$snsMode = this.getSnsMode();
                Object other$snsMode = other.getSnsMode();
                if (this$snsMode == null) {
                    if (other$snsMode != null) {
                        return false;
                    }
                } else if (!this$snsMode.equals(other$snsMode)) {
                    return false;
                }

                label74:
                {
                    Object this$snsType = this.getSnsType();
                    Object other$snsType = other.getSnsType();
                    if (this$snsType == null) {
                        if (other$snsType == null) {
                            break label74;
                        }
                    } else if (this$snsType.equals(other$snsType)) {
                        break label74;
                    }

                    return false;
                }

                label67:
                {
                    Object this$snsScene = this.getSnsScene();
                    Object other$snsScene = other.getSnsScene();
                    if (this$snsScene == null) {
                        if (other$snsScene == null) {
                            break label67;
                        }
                    } else if (this$snsScene.equals(other$snsScene)) {
                        break label67;
                    }

                    return false;
                }

                Object this$extObj = this.getExtObj();
                Object other$extObj = other.getExtObj();
                if (this$extObj == null) {
                    if (other$extObj != null) {
                        return false;
                    }
                } else if (!this$extObj.equals(other$extObj)) {
                    return false;
                }

                Object this$messages = this.getMessages();
                Object other$messages = other.getMessages();
                if (this$messages == null) {
                    if (other$messages != null) {
                        return false;
                    }
                } else if (!this$messages.equals(other$messages)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(final Object other) {
        return other instanceof BotRequest;
    }

    public int hashCode() {
        int result = 1;
        Object $snsCode = this.getSnsCode();
        result = result * 59 + ($snsCode == null ? 43 : $snsCode.hashCode());
        Object $snsTitle = this.getSnsTitle();
        result = result * 59 + ($snsTitle == null ? 43 : $snsTitle.hashCode());
        Object $snsMode = this.getSnsMode();
        result = result * 59 + ($snsMode == null ? 43 : $snsMode.hashCode());
        Object $snsType = this.getSnsType();
        result = result * 59 + ($snsType == null ? 43 : $snsType.hashCode());
        Object $snsScene = this.getSnsScene();
        result = result * 59 + ($snsScene == null ? 43 : $snsScene.hashCode());
        Object $extObj = this.getExtObj();
        result = result * 59 + ($extObj == null ? 43 : $extObj.hashCode());
        Object $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : $messages.hashCode());
        return result;
    }

    public String toString() {
        String var10000 = this.getSnsCode();
        return "BotRequest(snsCode=" + var10000 + ", snsTitle=" + this.getSnsTitle() + ", snsMode=" + this.getSnsMode() + ", snsType=" + this.getSnsType() + ", snsScene=" + this.getSnsScene() + ", extObj=" + this.getExtObj() + ", messages=" + this.getMessages() + ")";
    }
}
