package com.elitescloud.cloudt.system.model.vo.query.common;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Set;

/**
 * 组织分页查询.
 *
 * @author Kaiser（wang shao）
 * 2023/1/16
 */
@Data
@ApiModel(description = "组织分页查询")
public class CommonOrgPageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -3945934245817645983L;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID", position = 1)
    private Long ouId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织编码", position = 2)
    private String code;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", position = 3)
    private String name;

    /**
     * 是否实体组织
     */
    @ApiModelProperty(value = "是否行政组织", position = 4)
    private Boolean executive;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型[UDC]cloudt-system:orgType", position = 5)
    private String type;
    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型列表[UDC]cloudt-system:orgType", position = 5)
    private Set<String> types;

    /**
     * 排除掉的所属组织ID
     * <p>
     * 会将其及其下属组织都排除掉
     */
    @ApiModelProperty(value = "排除掉的所属组织ID", position = 6)
    private Long excludeBelongId;

    @ApiModelProperty(value = "上级组织编码", position = 7)
    private String parentCode;

    @ApiModelProperty(value = "启用状态", position = 9)
    private Boolean enabled;

    @ApiModelProperty(value = "外部组织编码", position = 10)
    private String outerCode;

    @ApiModelProperty(value = "特定上级组织类型", position = 21)
    private String withParentType;
}
