package com.elitescloud.cloudt.system.model.vo.query.extend;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 汇率分页查询参数.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "汇率分页查询参数")
public class CurrencyRatePageQueryVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -8442106501093995174L;

    /**
     * 自货币码
     */
    @ApiModelProperty(value = "自货币码", position = 1)
    private String fromCurr;

    /**
     * 至货币码
     */
    @ApiModelProperty(value = "至货币码", position = 2)
    private String toCurr;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    /**
     * 生效日期-开始
     */
    @ApiModelProperty(value = "生效日期-开始", position = 4)
    private LocalDateTime validFromS;

    /**
     * 生效日期-截止
     */
    @ApiModelProperty(value = "生效日期-截止", position = 5)
    private LocalDateTime validFromE;

    /**
     * 失效日期-开始
     */
    @ApiModelProperty(value = "失效日期-开始", position = 6)
    private LocalDateTime validToS;

    /**
     * 失效日期-截止
     */
    @ApiModelProperty(value = "失效日期-截止", position = 7)
    private LocalDateTime validToE;
}
