package com.elitescloud.cloudt.system.model.vo.query.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 汇率查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 3/15/2023
 */
@Data
@ApiModel(description = "汇率查询参数")
public class CurrencyRateQueryVO implements Serializable {
    private static final long serialVersionUID = -446943291933114948L;

    /**
     * 源货币
     */
    @NotBlank(message = "从货币不能为空")
    @ApiModelProperty(value = "从货币", position = 1, required = true)
    private String fromCurr;

    /**
     * 至货币
     */
    @NotBlank(message = "至货币不能为空")
    @ApiModelProperty(value = "至货币", position = 2, required = true)
    private String toCurr;

    /**
     * 有效时间
     */
    @ApiModelProperty(value = "至货币", position = 3)
    private LocalDateTime validDate;

    /**
     * 有效时间-起始时间
     */
    @ApiModelProperty(value = "至货币", position = 4)
    private LocalDateTime validFromS;

    /**
     * 有效时间-截止时间
     */
    @ApiModelProperty(value = "至货币", position = 5)
    private LocalDateTime validFromE;

    /**
     * 失效时间-起始时间
     */
    @ApiModelProperty(value = "至货币", position = 6)
    private LocalDateTime validToS;

    /**
     * 失效时间-截止时间
     */
    @ApiModelProperty(value = "至货币", position = 7)
    private LocalDateTime validToE;
}
