package com.elitescloud.cloudt.system.model.vo.resp.businessobject;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/3/13
 */
@Getter
@Setter
@ApiModel(description = "业务对象信息")
public class BusinessObjectDetailRespVO implements Serializable {
    private static final long serialVersionUID = 3278445103290518695L;

    @ApiModelProperty(value = "业务对象ID")
    private Long id;

    @ApiModelProperty(value = "应用编码")
    private String appCode;

    @ApiModelProperty(value = "应用名称")
    private String appName;

    @ApiModelProperty(value = "业务对象的编码")
    private String code;

    @ApiModelProperty(value = "业务对象的名称")
    private String name;

    @ApiModelProperty(value = "业务对象的描述")
    private String description;

    @ApiModelProperty(value = "领域分类")
    private String domain;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "是否是公共资源")
    private Boolean publicResource;

    @ApiModelProperty(value = "是否支持租户", hidden = true)
    private Boolean supportTenant;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "最近更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "业务对象参数")
    private List<BusinessObjectParamRespVO> paramList;

    @ApiModelProperty(value = "操作信息")
    private List<IdCodeNameParam> operationList;
}
