package com.elitescloud.cloudt.system.model.vo.resp.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 应用示例信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/7/8
 */
@Getter
@Setter
@ApiModel(description = "应用示例信息")
public class CommonAppInstanceRespVO implements Serializable {
    private static final long serialVersionUID = -8607748827079368305L;

    @ApiModelProperty(value = "服务实例ID", position = 1)
    private String serviceId;

    @ApiModelProperty(value = "服务名称", position = 2)
    private String serviceName;

    @ApiModelProperty(value = "服务实例地址", position = 3)
    private List<String> uris;

    @ApiModelProperty(value = "注册主机", position = 4)
    private List<Instance> instances;

    @Getter
    @Setter
    @ApiModel(value = "CommonAppInstanceRespVO_Instance", description = "应用示例信息")
    public static class Instance implements Serializable {
        private static final long serialVersionUID = 4100139823650174492L;

        @ApiModelProperty(value = "服务地址", position = 1)
        private String uri;

        @ApiModelProperty(value = "协议", position = 2)
        private String schema;

        @ApiModelProperty(value = "是否安全", position = 3)
        private boolean secure;

        @ApiModelProperty(value = "注册主机", position = 4)
        private String host;

        @ApiModelProperty(value = "注册端口", position = 5)
        private Integer port;
    }
}
