package com.elitescloud.cloudt.system.model.vo.resp.datarelation;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/14
 */
@Getter
@Setter
@ApiModel(description = "数据关系编辑信息")
public class DataRelationEditRespVO implements Serializable {
    private static final long serialVersionUID = 7507299705949602240L;

    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    @ApiModelProperty(value = "数据关系编码", position = 2)
    private String code;

    @ApiModelProperty(value = "数据关系名称", position = 3)
    private String name;

    @ApiModelProperty(value = "主业务对象编码", position = 4)
    private String boCode;

    @ApiModelProperty(value = "主业务对象名称", position = 4)
    private String boName;

    @ApiModelProperty(value = "关联的主业务对象编码", position = 5)
    private String refBoCode;

    @ApiModelProperty(value = "关联业务对象名称", position = 5)
    private String refBoName;

    @ApiModelProperty(value = "是否启用", position = 6)
    private Boolean enabled;

    @ApiModelProperty(value = "说明", position = 7)
    private String remark;

    @ApiModelProperty(value = "创建时间", position = 8)
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新时间", position = 9)
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "分类", position = 11)
    private List<Cat> cats;

    @ApiModelProperty(value = "数据选择器编码", position = 12)
    private String dataSelectorCode;
    @ApiModelProperty(value = "数据选择器名称", position = 12)
    private String dataSelectorName;

    @Getter
    @Setter
    @ApiModel(value = "DataRelationEditRespVO_Cat", description = "数据关系的分类")
    public static class Cat implements Serializable {
        private static final long serialVersionUID = -5836087492481620372L;

        @ApiModelProperty(value = "分类编码", position = 1)
        private String catCode;

        @ApiModelProperty(value = "分类名称", position = 2)
        private String catName;

        @ApiModelProperty(value = "是否启用", position = 3)
        private Boolean enabled;
    }
}
