package com.elitescloud.cloudt.system.model.vo.resp.extend;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/28
 */
@Data
@ApiModel(description = "导入（导出）数据记录")
public class TmplImportRecordRespVO implements Serializable {
    private static final long serialVersionUID = 8864768680913261992L;

    @ApiModelProperty(value = "记录ID")
    private Long id;

    @ApiModelProperty(value = "导入（导出）文件的唯一标识")
    private String fileCode;

    @ApiModelProperty(value = "导入（导出）文件信息")
    private FileObjRespVO<String> fileInfo;

    @ApiModelProperty(value = "导入（导出）文件信息列表")
    private List<FileObjRespVO<String>> fileInfoList;

    @ApiModelProperty(value = "用户ID")
    private Long userId;

    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ApiModelProperty(value = "导入（导出）开始时间")
    private LocalDateTime timeImport;

    @ApiModelProperty(value = "导入（导出）结束时间")
    private LocalDateTime timeFinish;

    @ApiModelProperty(value = "是否导入（导出）结束")
    private Boolean finish;

    @ApiModelProperty(value = "是否导入（导出）成功")
    private Boolean succ;

    @ApiModelProperty(value = "导入（导出）失败原因")
    private String failReason;

    @ApiModelProperty(value = "导入（导出）总记录数")
    private Long numTotal;

    @ApiModelProperty(value = "导入（导出）成功数量")
    private Long numSuc;

    @ApiModelProperty(value = "自定义失败信息，空则使用系统默认的")
    private String failMsgCustom;
}
