package com.elitescloud.cloudt.system.model.vo.resp.index;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 用户的数据权限信息.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/13
 */
@Data
@ApiModel(description = "用户的数据权限信息")
public class UserDataPermissionRespVO implements Serializable {
    private static final long serialVersionUID = -5524960992067013962L;

    @ApiModelProperty(value = "登录号")
    private String username;

    @ApiModelProperty(value = "姓名")
    private String fullName;

    @ApiModelProperty(value = "角色信息")
    private List<IdCodeNameParam> roles;

    @ApiModelProperty(value = "权限行规则")
    private List<RowRule> rowRuleList;

    @ApiModelProperty(value = "列权限")
    private List<ApiField> apiFieldList;

    @Data
    @ApiModel(value = "UserDataPermissionRespVO_RowRuleList", description = "行规则")
    public static class RowRule extends Base {
        private static final long serialVersionUID = -5738789362882714045L;

        @ApiModelProperty("是否是规则组")
        private Boolean ruleGroup;

        @ApiModelProperty("组内规则列表")
        private List<RowRule> groupRules;

        @ApiModelProperty("规则ID")
        private Long dprRuleId;

        @ApiModelProperty("规则名称")
        private String dprRuleName;

        @ApiModelProperty("规则关系（and-or）")
        private String dprRuleRelation;
        private String dprRuleRelationName;

        @ApiModelProperty("规则字段")
        private String dprRuleField;

        @ApiModelProperty("规则条件类型")
        private String dprRuleCondition;
        @ApiModelProperty("规则条件类型名称")
        private String dprRuleConditionName;

        @ApiModelProperty("规则值")
        private String dprRuleValue;

        @ApiModelProperty("规则值类型")
        private String dprRuleValueType;
        @ApiModelProperty("规则值类型名称")
        private String dprRuleValueTypeName;

        @ApiModelProperty(value = "数据集")
        private String dataSet;

        @ApiModelProperty("备用字段1")
        private String bs1;

        @ApiModelProperty("备用字段2")
        private String bs2;

        @ApiModelProperty("备用字段3")
        private String bs3;
    }

    @Data
    @ApiModel(value = "UserDataPermissionRespVO_ApiField", description = "行规则")
    public static class ApiField extends Base {
        private static final long serialVersionUID = -6425645931024462052L;

        @ApiModelProperty(name = "字段名称", notes = "")
        private String fieldName;

        @ApiModelProperty(name = "可读", notes = "")
        private Boolean readable;

        @ApiModelProperty(name = "可写", notes = "")
        private Boolean writeable;

        @ApiModelProperty(name = "api可见", notes = "")
        @Deprecated(since = "3.3.0")
        private Boolean fieldApiVisible;

        @ApiModelProperty(name = "表单可见", notes = "")
        @Deprecated(since = "3.3.0")
        private Boolean fieldFormVisible;

        @ApiModelProperty(name = "表单可编辑", notes = "")
        @Deprecated(since = "3.3.0")
        private Boolean fieldFormUpdate;
    }

    @Getter
    @Setter
    public static class Base implements Serializable {
        private static final long serialVersionUID = -5034451386798653796L;

        @ApiModelProperty("权限类型")
        private String permissionType;
        private String permissionTypeName;

        @ApiModelProperty("权限关联标识")
        private String permissionRef;
        private String permissionRefName;

        @ApiModelProperty("角色编码")
        private String roleCode;

        @ApiModelProperty("角色名称")
        private String roleName;

        @ApiModelProperty("应用编码")
        private String appCode;

        @ApiModelProperty("应用名称")
        private String appName;

        @ApiModelProperty("业务对象编码")
        private String businessObjectCode;

        @ApiModelProperty("业务对象名称")
        private String businessObjectName;

        @ApiModelProperty("业务操作路径")
        private String apiPermissionPath;

        @ApiModelProperty("业务操作方法")
        private String apiPermissionRequestType;

        @ApiModelProperty("业务操作编码")
        private String apiPermissionCode;

        @ApiModelProperty("业务操作名称")
        private String apiPermissionName;

        @ApiModelProperty("菜单编码")
        private String menusCode;

        @ApiModelProperty("菜单名称")
        private String menusName;

        @ApiModelProperty("菜单路由")
        private String menusRoute;
    }
}
