package com.elitescloud.cloudt.system.model.vo.resp.org;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 员工组的员工信息.
 *
 * @author Kaiser（wang shao）
 * 2023/1/16
 */
@Data
@ApiModel(description = "员工组的员工信息")
public class EmpGroupEmpPageRespVO implements Serializable {
    private static final long serialVersionUID = -5528869095027273569L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 2)
    private Long employeeId;
    private Long userId;

    /**
     * 员工编码
     */
    @ApiModelProperty(value = "员工编码", position = 3)
    private String employeeCode;

    /**
     * 员工姓名
     */
    @ApiModelProperty(value = "员工姓名", position = 5)
    private String employeeName;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 6)
    private String username;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 7)
    private String duty;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否在职", position = 9)
    private Boolean served;

    /**
     * 添加时间
     */
    @ApiModelProperty(value = "添加时间", position = 11)
    private LocalDateTime createTime;
}
