package com.elitescloud.cloudt.system.model.vo.resp.org;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工分页信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "员工分页信息")
public class EmployeePagedRespVO extends CustomFieldAbstractVo implements Serializable {
    private static final long serialVersionUID = -8015944791970242430L;

    /**
     * 员工ID
     */
    @ApiModelProperty(value = "员工ID", position = 1)
    private Long id;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 2)
    private Long userId;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号", position = 3)
    private String code;

    /**
     * 职务
     */
    @ApiModelProperty(value = "职务", position = 3)
    private String duty;

    /**
     * 登录账号
     */
    @ApiModelProperty(value = "登录账号", position = 4)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 5)
    private String fullName;
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String firstName;
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    private String lastName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 6)
    private String gender;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别名称", position = 6)
    private String genderName;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型", position = 7)
    @SysCode(sys = Application.NAME, mod = EmployeeType.UDC_CODE)
    private String type;

    /**
     * 类型名称
     */
    @ApiModelProperty(value = "类型名称", position = 7)
    private String typeName;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话", position = 8)
    private String mobile;

    /**
     * 电话
     */
    @ApiModelProperty(value = "办公电话", position = 8)
    private String phone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 10)
    private Boolean enabled;

    /**
     * 是否在职
     */
    @ApiModelProperty(value = "是否在职", position = 10)
    private Boolean served;

    /**
     * 入职时间
     */
    @ApiModelProperty(value = "入职时间", position = 11)
    private LocalDateTime joinTime;

    /**
     * 所在组织
     */
    @ApiModelProperty(value = "所在组织", position = 21)
    private List<String> orgNameList;

    /**
     * 员工角色
     */
    @ApiModelProperty(value = "员工角色", position = 22)
    private List<String> roleNameList;

    /**
     * 是否没有登录账号
     */
    @ApiModelProperty(value = "是否没有登录账号,默认否", position = 99)
    private Boolean withoutLoginAccount;

    /**
     * 员工照片
     */
    @ApiModelProperty(value = "员工照片")
    private String photo;
}
