package com.elitescloud.cloudt.system.model.vo.resp.org;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 组织节点信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@Data
@ApiModel(description = "组织节点信息")
public class OrgDetailRespVO implements Serializable {
    private static final long serialVersionUID = -5384670956277405003L;

    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID", position = 1)
    private Long id;

    /**
     * 上级组织编码
     */
    @ApiModelProperty(value = "上级组织编码", position = 2)
    private String parentCode;

    /**
     * 上级组织ID
     */
    @ApiModelProperty(value = "上级ID", position = 2)
    private Long parentId;

    /**
     * 上级组织名称
     */
    @ApiModelProperty(value = "上级名称", position = 2)
    private String parentName;

    /**
     * 是否行政组织
     */
    @ApiModelProperty(value = "是否行政组织", position = 3)
    private Boolean executive;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织编码", position = 2)
    private String code;

    @ApiModelProperty(value = "外部组织编码", position = 2)
    private String outerCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", position = 4)
    private String name;

    /**
     * 简称
     */
    @ApiModelProperty(value = "简称", position = 5)
    private String shortName;

    /**
     * 英文名称
     */
    @ApiModelProperty(value = "英文名称", position = 6)
    private String englishName;

    /**
     * 组织类型
     */
    @ApiModelProperty(value = "组织类型", position = 7)
    private String type;

    /**
     * 组织类型名称
     */
    @ApiModelProperty(value = "组织类型名称", position = 8)
    private String typeName;

    /**
     * 是否实体组织
     */
    @ApiModelProperty(value = "是否实体组织", position = 9)
    private Boolean entity;

    /**
     * 顺序
     */
    @ApiModelProperty(value = "顺序", position = 10)
    private Integer sortNo;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 11)
    private Boolean enabled;

    /**
     * 是否外部同步
     */
    @ApiModelProperty(value = "是否外部同步", position = 11)
    private Boolean syncOuter;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID", position = 12)
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称", position = 13)
    private String ouName;

    /**
     * 区域
     * <p>
     * [UDC]cloudt-system:region {@link com.elitescloud.cloudt.constant.SysRegion}
     */
    @ApiModelProperty(value = "区域,[UDC]cloudt-system:region", position = 14)
    private String region;
    private String regionName;

    /**
     * 事业部
     * <p>
     * [UDC]cloudt-system:businessUnit {@link com.elitescloud.cloudt.constant.SysBusinessUnit}
     */
    @ApiModelProperty(value = "事业部，[UDC]cloudt-system:businessUnit", position = 15)
    private String businessUnit;
    private String businessUnitName;

    /**
     * 利润中心
     * <p>
     * [UDC]cloudt-system:profitablyCenter {@link com.elitescloud.cloudt.constant.SysProfitablyCenter}
     */
    @ApiModelProperty(value = "利润中心，[UDC]cloudt-system:profitablyCenter", position = 16)
    private String profitablyCenter;
    private String profitablyCenterName;

    /**
     * 职能类型
     * <p>
     * [UDC]cloudt-system:functionType {@link com.elitescloud.cloudt.constant.SysFunctionType}
     */
    @ApiModelProperty(value = "职能类型，[UDC]cloudt-system:functionType", position = 17)
    private String functionType;
    private String functionTypeName;

    /**
     * 深度
     */
    @ApiModelProperty(value = "深度", position = 18)
    private Integer depth;

    /**
     * 指定上级
     */
    @ApiModelProperty(value = "指定上级", position = 19)
    private IdCodeNameParam withParent;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 21)
    private String remark;
}
