package com.elitescloud.cloudt.system.model.vo.resp.role;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/22 周四
 */
@Getter
@Setter
public class UserRoleDataPermissionRespVO implements Serializable {
    private static final long serialVersionUID = -5767497488311818997L;

    @ApiModelProperty(value = "角色编码")
    private String roleCode;

    @ApiModelProperty(value = "角色名称")
    private String roleName;

    @ApiModelProperty(value = "数据权限列表")
    private List<DataPermission> dataPermissions;

    @Getter
    @Setter
    public static class DataPermission implements Serializable {
        private static final long serialVersionUID = -803731285848648379L;

        /**
         * 权限类型
         * <p>
         * 取值：{@link com.elitescloud.cloudt.system.constant.DataPermissionType}
         */
        @ApiModelProperty(value = "权限类型")
        private String permissionType;
        @ApiModelProperty(value = "权限类型名称")
        private String permissionTypeName;

        @ApiModelProperty(value = "关联权限")
        private String permissionRef;

        @ApiModelProperty(value = "应用编码")
        private String appCode;
        @ApiModelProperty(value = "应用名称")
        private String appName;

        @ApiModelProperty(value = "业务对象编码")
        private String businessObjectCode;
        @ApiModelProperty(value = "业务对象名称")
        private String businessObjectName;

        @ApiModelProperty(value = "业务操作的编码")
        private String apiPermissionCode;
        @ApiModelProperty(value = "业务操作名称")
        private String apiPermissionName;

        @ApiModelProperty(value = "菜单编码")
        private String menusCode;
        @ApiModelProperty(value = "菜单名称")
        private String menusName;

        @ApiModelProperty(value = "行权限表达式")
        private String rowPermissionExpression;

        @ApiModelProperty(value = "行权限值表达式")
        private String rowPermissionValueExpression;

        @ApiModelProperty(value = "行权限")
        private List<RowPermission> rowPermissions;

        @ApiModelProperty(value = "字段权限")
        private List<FieldPermission> fieldPermissions;
    }

    @Getter
    @Setter
    public static class RowPermission implements Serializable {
        private static final long serialVersionUID = 2738768459747901731L;

        @ApiModelProperty(value = "是否是规则组")
        private Boolean ruleGroup;

        @ApiModelProperty(value = "组内规则关系，且、或")
        private String dprRuleRelation;

        @ApiModelProperty(value = "组内规则")
        private List<RowPermission> groupRuleList;

        @ApiModelProperty(value = "规则名称")
        private String dprRuleName;

        @ApiModelProperty(value = "字段")
        private String dprRuleField;
        @ApiModelProperty(value = "字段名称")
        private String dprRuleFieldName;

        @ApiModelProperty(value = "是否引用了资源")
        private Boolean refResource;

        @ApiModelProperty(value = "引用的资源对象编码")
        private String refBusinessObject;
        @ApiModelProperty(value = "引用的资源对象名称")
        private String refBusinessObjectName;

        @ApiModelProperty(value = "引用的资源字段")
        private String refField;
        @ApiModelProperty(value = "引用的资源字段名称")
        private String refFieldName;

        @ApiModelProperty(value = "条件类型")
        private String dprRuleCondition;
        @ApiModelProperty(value = "条件值类型名称")
        private String dprRuleConditionName;

        @ApiModelProperty(value = "条件值类型")
        private String dprRuleValueType;
        @ApiModelProperty(value = "条件值类型名称")
        private String dprRuleValueTypeName;

        @ApiModelProperty(value = "条件值")
        private String dprRuleValue;
        private String dprRuleValueName;

        @ApiModelProperty(value = "备用字段1")
        private String bs1;

        @ApiModelProperty(value = "备用字段2")
        private String bs2;

        @ApiModelProperty(value = "备用字段3")
        private String bs3;
    }

    @Getter
    @Setter
    public static class FieldPermission implements Serializable {
        private static final long serialVersionUID = -1843158296984290134L;

        @ApiModelProperty(value = "字段名称")
        private String fieldName;

        @ApiModelProperty(value = "字段描述")
        private String fieldDescription;

        @ApiModelProperty(value = "是否可读")
        private Boolean readable;

        @ApiModelProperty(value = "是否可写")
        private Boolean writeable;
    }
}
