package com.elitescloud.cloudt.system.model.vo.resp.role;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.system.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserMenuRespVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/5/21 周三
 */
@Getter
@Setter
public class UserRoleMenuRespVO implements Serializable {
    private static final long serialVersionUID = 116515823049600973L;

    @ApiModelProperty(value = "菜单编码", position = 1)
    private String menuCode;

    @ApiModelProperty(value = "菜单名称", position = 2)
    private String menuName;

    @ApiModelProperty(value = "父菜单编码", position = 3)
    private String parentMenuCode;

    @ApiModelProperty(value = "菜单图标", position = 4)
    private String menusIcon;

    @ApiModelProperty(value = "节点类型", position = 6)
    private String nodeType;

    @ApiModelProperty(value = "数据实际类型", position = 6)
    private String dataType;

    @ApiModelProperty(value = "顺序", position = 7)
    private Integer sortNo;

    @ApiModelProperty(value = "是否显示", position = 8)
    private Boolean display;

    @ApiModelProperty(value = "授权的角色", position = 9)
    private List<CodeNameParam> roles;

    @ApiModelProperty(value = "是否有子节点", position = 11)
    private Boolean hasChildren;

    @ApiModelProperty(value = "子节点列表", position = 12)
    private List<UserRoleMenuRespVO> children;


    public String getParentMenuCode() {
        if (!StringUtils.hasText(parentMenuCode)) {
            return null;
        }
        return parentMenuCode;
    }

    public Boolean getHasChildren() {
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return hasChildren;
    }
}
