package com.elitescloud.cloudt.system.model.vo.resp.udc;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * UDC详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "UDC详细信息")
public class UdcDetailRespVO implements Serializable {
    private static final long serialVersionUID = -4552320202323972129L;

    /**
     * UDC的ID
     */
    @ApiModelProperty(value = "UDC的ID", position = 1)
    private Long id;

    /**
     * UDC的编码
     */
    @ApiModelProperty(value = "UDC的编码", position = 2)
    private String udcCode;

    /**
     * UDC的名称
     */
    @ApiModelProperty(value = "UDC的名称", position = 3)
    private String udcName;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 4)
    private String udcDescribe;

    /**
     * 是否允许编辑
     */
    @ApiModelProperty(value = "是否允许编辑", position = 5)
    private Boolean allowUpdate;

    /**
     * 是否允许新增
     */
    @ApiModelProperty(value = "是否允许新增", position = 6)
    private Boolean allowAddValue;

    /**
     * 上级UDC编码
     */
    @ApiModelProperty(value = "上级UDC编码", position = 7)
    private String parentUdcCode;

    /**
     * 值列表
     */
    @ApiModelProperty(value = "值列表", position = 11)
    private List<UdcValueRespVO> valueList;
}
