package com.elitescloud.cloudt.system.model.vo.resp.user;

import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UserTypeRespVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 用户详细信息.
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@ApiModel(description = "用户详细信息")
@Data
public class UserDetailRespVO  implements Serializable {
    private static final long serialVersionUID = -305970628122366622L;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID", position = 1)
    private Long id;

    /**
     * 用户账号
     */
    @ApiModelProperty(value = "用户账号", position = 2)
    private String username;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名", position = 4)
    private String fullName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", position = 5)
    private String gender;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别名称", position = 5)
    private String genderName;

    /**
     * 昵称
     */
    @ApiModelProperty(value = "昵称", position = 6)
    private String nickName;

    /**
     * 生日
     */
    @ApiModelProperty(value = "生日", position = 7)
    private LocalDate birthDate;

    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号", position = 8)
    private String mobile;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", position = 9)
    private String email;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 10)
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    @ApiModelProperty(value = "账号过期时间", position = 11)
    private LocalDateTime expiredTime;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号", position = 12)
    private String idCard;

    /**
     * 所在地
     */
    @ApiModelProperty(value = "所在地", position = 13)
    private AreaVO areaVO;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址", position = 16)
    private String address;

    /**
     * 个性签名
     */
    @ApiModelProperty(value = "个性签名", position = 17)
    private String personalSign;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 18)
    private String remark;

    /**
     * 账户类型
     */
    @ApiModelProperty(value = "账户类型", position = 21)
    private List<UserTypeRespVO> userTypes;
}
