package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 企业微信.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
@Data
@ApiModel(description = "企业微信")
public class AlertConfigWxWorkSaveVO extends AlertConfigBaseSaveVO {
    private static final long serialVersionUID = 1064840336573662L;

    /**
     * 地址
     */
    @ApiModelProperty(value = "地址", position = 1, required = true)
    private Map<String, List<String>> webhookUrls;

    /**
     * 消息模板
     */
    @ApiModelProperty(value = "消息模板", position = 2)
    private String tmplContent;

    /**
     * 是否去重
     */
    @ApiModelProperty(value = "是否去重，默认否", position = 3)
    private Boolean deduplicate;

    /**
     * 去重字段
     */
    @ApiModelProperty(value = "去重字段", position = 4)
    private List<String> deduplicateFields;

    /**
     * 去重间隔
     * <p>
     * 单位分钟
     */
    @ApiModelProperty(value = "去重间隔，单位分钟", position = 5)
    private Integer deduplicateIntervals;
}
