package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 公告保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/4/22
 */
@Getter
@Setter
@ApiModel(description = "公告保存信息")
public class NoticeSaveVO implements Serializable {
    private static final long serialVersionUID = -6758701987192402045L;

    @ApiModelProperty(value = "公告ID，编辑时不可为空", position = 1)
    private Long id;

    @NotBlank(message = "标题不可为空")
    @ApiModelProperty(value = "公告标题", position = 2, required = true)
    private String title;

    @ApiModelProperty(value = "公告摘要", position = 3)
    private String summaries;

    @ApiModelProperty(value = "作者用户ID，为空则取当前用户", position = 4)
    private Long authorId;

    @ApiModelProperty(value = "分类，[UDC]cloudt-system:noticeCategory", position = 5)
    private String category;

    @ApiModelProperty(value = "公告类型", position = 6)
    private String noticeType;

    @ApiModelProperty(value = "是否置顶", position = 7)
    private Boolean top;

    @ApiModelProperty(value = "发布时间", position = 8)
    private LocalDateTime publishTime;

    @ApiModelProperty(value = "公告内容", position = 9)
    private String txt;

    @ApiModelProperty(value = "公告附件的唯一标识", position = 10)
    private List<String> fileCodes;

    @ApiModelProperty(value = "是否是系统公告", position = 21)
    private Boolean sys;

    @ApiModelProperty(value = "备注")
    private String remark;
}
