package com.elitescloud.cloudt.system.model.vo.save.extend;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 税率保存参数.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "税率保存参数")
public class TaxRateSaveVO {
    /**
     * 记录ID，编辑时不可为空
     */
    @ApiModelProperty(value = "记录ID，编辑时不可为空", position = 1)
    private Long id;

    /**
     * 税率类型
     */
    @ApiModelProperty(value = "税率类型，UDC[cloudt-system:taxRateType]", position = 2)
    private String taxRateType;

    /**
     * 税率编码
     */
    @ApiModelProperty(value = "税率编码", position = 3, required = true)
    @NotBlank(message = "税率编码为空")
    private String taxRateNo;

    /**
     * 税率说明
     */
    @ApiModelProperty(value = "税率说明", position = 4)
    private String taxRateDesc;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期", position = 5)
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期", position = 6)
    private LocalDateTime validTo;

    /**
     * 税率值
     */
    @ApiModelProperty(value = "税率值", position = 7, required = true)
    @NotNull(message = "税率值为空")
    private BigDecimal taxRateValue;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 8)
    private Boolean enabled;
}
