package com.elitescloud.cloudt.system.model.vo.save.menu;

import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * 菜单树节点.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "菜单树节点")
public class MenuTreeSaveVO implements Serializable {
    private static final long serialVersionUID = -6044178680494632724L;

    /**
     * 菜单编码
     */
    @ApiModelProperty(value = "菜单编码", position = 1, required = true)
    @NotBlank(message = "菜单编码为空")
    private String menuCode;

    /**
     * 菜单名称
     */
    @ApiModelProperty(value = "菜单名称", position = 2, required = true)
    @NotBlank(message = "菜单名称为空")
    private String menuName;

    /**
     * 节点类型
     * {@link MenuTreeNodeType}
     */
    @ApiModelProperty(value = "节点类型", position = 3, required = true)
    @NotBlank(message = "节点类型为空")
    private String nodeType;

    /**
     * 父节点编码
     */
    @ApiModelProperty(value = "父节点编码", position = 4)
    private String parentMenuCode;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标", position = 5)
    private String menusIcon;

    /**
     * 是否自定义节点
     */
    @ApiModelProperty(value = "是否是自定义菜单", position = 6)
    private Boolean custom;

    /**
     * 子节点列表
     */
    @ApiModelProperty(value = "子节点列表", position = 11)
    @Valid
    private List<MenuTreeSaveVO> children;
}
