package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 接口挂载菜单.
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/8
 */
@Data
@ApiModel(description = "接口挂载菜单信息")
public class MenuApiSaveVO implements Serializable {
    private static final long serialVersionUID = -949411966430950289L;

    @ApiModelProperty(value = "应用编码，为空则是所有应用")
    private String appCode;

    @ApiModelProperty(value = "接口ID", required = true)
    @NotNull(message = "请选择接口")
    private Long apiId;

    @ApiModelProperty(value = "菜单ID")
    private Set<Long> menuIds;
}
