package com.elitescloud.cloudt.system.model.vo.save.role;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 角色权限复制.
 *
 * @author Kaiser（wang shao）
 * @date 2025/1/14
 */
@Getter
@Setter
public class RolePermissionCopySaveVO implements Serializable {
    private static final long serialVersionUID = 6456214928613483526L;

    @NotNull(message = "原角色ID为空")
    @ApiModelProperty(value = "原角色ID", required = true, position = 1)
    private Long originalRoleId;

    @NotNull(message = "目标角色ID为空")
    @ApiModelProperty(value = "目标角色ID", required = true, position = 2)
    private Set<Long> targetIds;

    @ApiModelProperty(value = "应用编码，为空的话是所有应用", position = 3)
    private String appCode;

    @ApiModelProperty(value = "是否合并权限，true：合并，false：清空原有的，默认true", position = 4)
    private Boolean merge;
}
