package com.elitescloud.cloudt.system.model.vo.save.sys;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 数据选择器保存信息.
 *
 * @author Kaiser（wang shao）
 * @date 2024/5/16
 */
@Getter
@Setter
@ApiModel(description = "数据选择器保存信息")
public class DataSelectorSaveVO implements Serializable {
    private static final long serialVersionUID = -6476131298656382178L;

    @ApiModelProperty(value = "ID，修改时不可为空")
    private Long id;

    @NotBlank(message = "分组编码为空")
    @ApiModelProperty(value = "分组编码", position = 1, required = true)
    private String groupCode;

    @NotBlank(message = "编码为空")
    @ApiModelProperty(value = "选择器编码，不可为空且唯一，设置后不可修改", position = 2, required = true)
    private String selectorCode;

    @NotBlank(message = "名称为空")
    @ApiModelProperty(value = "名称", position = 3, required = true)
    private String selectorName;

    @ApiModelProperty(value = "是否启用", position = 3)
    private Boolean enabled;

    @ApiModelProperty(value = "是否是公共组件", position = 4, required = true)
    private Boolean component;

    @ApiModelProperty(value = "组件编码", position = 5)
    private String componentCode;

    @ApiModelProperty(value = "数据接口API", position = 11)
    private String dataApi;

    @ApiModelProperty(value = "数据接口请求方式", position = 12)
    private String dataApiMethod;

    @ApiModelProperty(value = "数据格式", position = 13)
    private String dataStyle;

    @ApiModelProperty(value = "数据接口请求头", position = 14)
    private Map<String, String> apiHeaders;

    @ApiModelProperty(value = "数据接口请求体", position = 15)
    private Map<String, Object> apiReqBody;

    @ApiModelProperty(value = "数据接口查询参数", position = 16)
    private Map<String, String> apiReqParams;

    @ApiModelProperty(value = "使用的数据字段", position = 17)
    private List<String> dataFields;

    @ApiModelProperty(value = "可选值的数量,小于0表示不受限制", position = 18)
    private Integer valueNumLimit;

    @ApiModelProperty(value = "扩展属性", position = 21)
    private Map<String, Object> extAttributes;
}
