package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.service.repo.EmpGroupEmpRepoProc;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;

/**
 * 同员工组的员工.
 *
 * @author Kaiser（wang shao）
 * @date 2024/9/9
 */
@Service
public class DprSysInternallyEmployeeGroupEmp implements DprValueResolverSPI {

    @Autowired
    private EmpGroupEmpRepoProc empGroupEmpRepoProc;

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[]{SysDprValueType.DPR_SYS_INTERNALLY_EMP_GROUP};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails generalUserDetails, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();

        // 员工组的员工
        var empId = generalUserDetails.getUser().getEmployeeId();
        List<Long> userIds = empId == null ? Collections.emptyList() : empGroupEmpRepoProc.queryEmpUserIdOfSameGroup(empId);
        dprRuleValueSysInternallyBo.setValue(userIds);
        return dprRuleValueSysInternallyBo;
    }
}
