package com.elitescloud.cloudt.system.modules.dpr.strategy.impl;

import com.elitescloud.boot.datasecurity.common.extension.DprValueResolverSPI;
import com.elitescloud.boot.datasecurity.common.extension.DprValueType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.modules.dpr.strategy.DprSysInternallyStrategyUtil;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:25
 */
@Service
@Slf4j
public class DprSysInternallyOrgLocalSub implements DprValueResolverSPI {

    @Autowired
    private OrgQueryService orgQueryService;

    @Override
    public @NotEmpty DprValueType[] valueTypes() {
        return new DprValueType[] {SysDprValueType.DPR_SYS_INTERNALLY_ORG_LOCAL_SUB};
    }

    @Override
    public DprRuleValue resolve(@NotNull DprValueType dprValueType, @NotNull GeneralUserDetails userInfo, @NotNull SysDprRoleApiDataRuleListQueryDTO sysDprRoleApiDataRuleListQueryDTO) {
        DprRuleValue dprRuleValueSysInternallyBo = new DprRuleValue();

        // 所在组织及下级组织
        var belongOrgIds = DprSysInternallyStrategyUtil.queryBelongOrgId(orgQueryService, userInfo.getOrgId());
        List<Long> orgIds = new ArrayList<>(belongOrgIds);
        orgIds.add(userInfo.getOrgId());
        dprRuleValueSysInternallyBo.setValue(orgIds);

        return dprRuleValueSysInternallyBo;
    }
}
