package com.elitescloud.cloudt.system.modules.finereport.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.util.MultiValueMap;

import java.io.Serializable;

/**
 * 查看报表参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/6/21
 */
@Getter
@Setter
@ApiModel(description = "查看报表参数")
public class ViewReportParamRespVO implements Serializable {
    private static final long serialVersionUID = -7154985146815623724L;

    @ApiModelProperty(value = "服务端地址", position = 1)
    private String serverAddr;

    @ApiModelProperty(value = "接口地址", position = 2)
    private String uri;

    @ApiModelProperty(value = "URI参数", position = 3)
    private MultiValueMap<String, String> uriParams;

    @ApiModelProperty(value = "url地址", position = 4)
    private String url;
}
