package com.elitescloud.cloudt.system.modules.message.sbean;

import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.cloudt.system.model.vo.sbean.BasicsBean;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/25 09:08
 */
@SearchBean(
        tables = "sys_msg_send_record_dtl so",
        where = "so.delete_flag = 0",
        autoMapTo="so"
//        dataSource = "systemDs"
)
@Data
public class SysMsgSendRecordDtlQueryBean extends BasicsBean {
    @ApiModelProperty("消息发送主表")
    private Long msgSendRecordId;

    @ApiModelProperty("消息类型-枚举-模板-自定义")
    private String msgType;

    @ApiModelProperty("发送状态-枚举-发送中，成功，失败")
    private String sendState;

    @ApiModelProperty("发送类型-短信-邮箱-站内信-站内提醒websoket")
    private String sentTypeCode;

    @ApiModelProperty("发送类型名称")
    private String sendTypeName;

//    @ApiModelProperty("发送类型的配置参数json（冗余，展示，重试，追溯使用）")
//    private String sendTypeConfigJson;

    @ApiModelProperty("发送时间开始")
    private LocalDateTime sentTimeStart;

    @ApiModelProperty("发送时间结束")
    private LocalDateTime sentTimeEnd;

    @ApiModelProperty("发送回执信息")
    private String sentEndMessage;

    @ApiModelProperty("发送系统内异常信息")
    private String sentErrMessage;

    @ApiModelProperty("发送人id")
    private String sendUserId;

    @ApiModelProperty("发送人名称")
    private String sendUserName;

    @ApiModelProperty("接收人名称")
    private String recipientUserName;

    @ApiModelProperty("接收人id")
    private String recipientUserId;

    @ApiModelProperty("接收人编码")
    private String recipientUserCode;

    @ApiModelProperty("模板id")
    private Long templateId;

    @ApiModelProperty("模板编码")
    private String templateCode;

    @ApiModelProperty("模板名称")
    private String templateName;

    @ApiModelProperty("主题-暂定udc")
    private String subject;

//    @ApiModelProperty("模板标题上下文参数json")
//    private String titleContentJson;

    @ApiModelProperty("标题内容")
    private String titleContent;

    @ApiModelProperty("消息内容")
    private String messageContent;

//    @ApiModelProperty("模板内容上下文参数json")
//    private String templateContentJson;

    @ApiModelProperty("外部模板id")
    private String externalTemplateId;

    @ApiModelProperty("自定义json参数")
    private String customParamJson;
    @ApiModelProperty("自定义参数")
    @DbIgnore
    private Map<String, Object> customParam;
//    @ApiModelProperty("扩展参数1")
//    private String extend1;
//
//    @ApiModelProperty("扩展参数2")
//    private String extend2;
//
//    @ApiModelProperty("扩展参数3")
//    private String extend3;
//
//    @ApiModelProperty("扩展参数4")
//    private String extend4;

//    @ApiModelProperty("扩展参数5")
//    private String extend5;

    @ApiModelProperty("是否已读")
    private Boolean readFlg;
    @ApiModelProperty("已读时间")
    private String readTime;
    @ApiModelProperty("批量号")
    private String batchUuid;

}
