package com.elitescloud.cloudt.system.modules.orgtree.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.resp.EmpOrgTreeOrgDTO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.*;
import com.elitescloud.cloudt.system.modules.orgtree.model.vo.*;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
@RestController
@RequestMapping("/org/orgBuTree")
@RequiredArgsConstructor
@Api(value = "组织树", tags = {"组织树"})
public class OrgBuTreeController {

    private final OrgBuTreeService orgBuTreeService;
    private final OrgBuTreeDService orgBuTreeDService;

    @PostMapping("/list")
    @ApiOperation("组织树分页条件查询")
    public ApiResult<PagingVO<OrgBuTreePagingVO>> search(@RequestBody OrgBuTreePagingParam param) {
        var result = orgBuTreeService.queryOrgBuTreeByParams(param);
        return ApiResult.ok(result);
    }

    @GetMapping("/getById/{id}")
    @ApiOperation("通过组织树id获取详细信息")
    public ApiResult<OrgBuTreeDetailVO> searchById(@PathVariable Long id) {
        var result = orgBuTreeService.getOrgBuTreeDetailById(id);
        return ApiResult.ok(result);
    }
    @PostMapping("/searchOrgByOrgTreeCodeAndEmpId")
    @ApiOperation("根据组织树编码和员工编码查询本机和下级组织")
    public ApiResult<List<EmpOrgTreeOrgDTO>> searchByOrgTreeCodeAndEmpId(@RequestBody com.elitescloud.cloudt.system.param.SearchByOrgTreeCodeAndEmpIdParam param) {
        var result = orgBuTreeDService.searchOrgByOrgTreeCodeAndEmpId(param);
        return result;
    }

    @PostMapping("/create")
    @ApiOperation("组织树新增、更新接口")
    public ApiResult<String> saveOrUpdate(@RequestBody OrgBuTreeSaveParam param) {
        var result = orgBuTreeService.orgBuTreeSaveOrUpdate(param);
        return ApiResult.ok(String.valueOf(result));
    }

    @PostMapping("/createTreeDetail")
    @ApiOperation("组织树节点新增")
    public ApiResult<List<OrgBuTreeDDetailVO>> createTreeDetail(@RequestBody List<OrgBuTreeDSaveParam> paramList) {
        var result = orgBuTreeDService.orgBuTreeDCreate(paramList);
        return ApiResult.ok(result);
    }

    @DeleteMapping("/deleteTreeDetail/{id}&{buTreedId}")
    @ApiOperation("组织树节点删除")
    public ApiResult<Object> deleteTreeDetail(@PathVariable String id, @PathVariable String buTreedId) {
        orgBuTreeDService.deleteTreeDetail(Long.valueOf(id), Long.valueOf(buTreedId));
        return ApiResult.ok();
    }

    @PutMapping("/updateStatus")
    @ApiOperation("组织树确认、停用")
    public ApiResult<Object> updateStatus(@RequestBody OrgBuTreeStatusParam param) {
        orgBuTreeService.updateStatus(param);
        return ApiResult.ok();
    }


    @GetMapping("/nextSearch/{id}&{buTreeId}&{searchType}")
    @ApiOperation("组织树明细列表显示内容,searchType:ALL(查询下面所有级别)，NEXT(查询下一级)")
    public ApiResult<List<OrgBuTreedAllVO>> orgBuTreedAllSearch(@PathVariable("id") String id, @PathVariable("searchType") String searchType, @PathVariable String buTreeId) {
        var result = orgBuTreeDService.orgBuTreedAllSearch(Long.valueOf(id), searchType, Long.valueOf(buTreeId));
        return ApiResult.ok(result);
    }

    @GetMapping("/treeSearch/{id}&{searchType}")
    @ApiOperation("组织树明细树形显示内容,searchType:ALL(包括已停用)，NEXT(不包括)")
    public ApiResult<List<OrgBuTreeDVO>> orgBuTreeDSearchTree(@PathVariable String id, @PathVariable String searchType) {
        var result = orgBuTreeDService.orgBuTreeDSearchTree(Long.valueOf(id), searchType, null);
        return ApiResult.ok(result);
    }

    @PostMapping("/treeVersion/save")
    @ApiOperation("新增/编辑 组织树版本数据")
    public ApiResult<Object> saveBuTreeDV(@RequestBody OrgBuTreeVSaveParam param) {
        orgBuTreeDService.saveBuTreeDV(param);
        return ApiResult.ok();
    }

    @PostMapping("/treeVersion/getResume")
    @ApiOperation("根据param获取组织树履历数据")
    public ApiResult<PagingVO<OrgBuTreeVO>> getBuTreePagingByParam(@RequestBody OrgBuTreeVPagingParam param) {
        return ApiResult.ok(orgBuTreeService.getBuTreePagingByParam(param));
    }

    @PostMapping("/treeVersion/get")
    @ApiOperation("根据param获取组织树版本数据")
    public ApiResult<List<OrgBuTreeVO>> getBuTreeListByBuTreeCode(@RequestBody OrgBuTreeVListParam param) {
        return ApiResult.ok(orgBuTreeDService.getBuTreeListByParam(param));
    }


    @PostMapping("/treeVersion/getTreeD")
    @ApiOperation("根据param获取组织树版本节点数据")
    public ApiResult<OrgBuTreeAndTreeDVO> getBuTreeDListByBuTreeCode(@RequestBody OrgBuTreeVListParam param) {
        return ApiResult.ok(orgBuTreeDService.getBuTreeDListByParam(param));
    }

    @GetMapping("/treeVersion/getV/{buTreeCode}")
    @ApiOperation("根据组织树编码获取组织树版本号数据")
    public ApiResult<List<String>> getBuTreeVersionByBuTreeCode(@PathVariable String buTreeCode) {
        return ApiResult.ok(orgBuTreeDService.getBuTreeVersionByBuTreeCode(buTreeCode));
    }

    @GetMapping("/treeVersion/releaseV/{id}")
    @ApiOperation("根据组织树id发布组织树版本")
    public ApiResult<Object> releaseBuTreeVersion(@PathVariable Long id) {
        orgBuTreeDService.releaseBuTreeVersion(id);
        return ApiResult.ok();
    }

    @GetMapping("/treeVersion/getFlag/{buTreeCode}")
    @ApiOperation("根据组织树编码获取是否可以创建新版本组织树标识")
    public ApiResult<Boolean> getCreateNewVersionFlag(@PathVariable String buTreeCode) {
        return ApiResult.ok(orgBuTreeService.getCreateNewVersionFlag(buTreeCode));
    }

    @DeleteMapping("/treeVersion/delete/{id}")
    @ApiOperation("根据id删除草稿状态的组织树")
    public ApiResult<Object> deleteBuTreeById(@PathVariable Long id) {
        orgBuTreeService.deleteBuTreeById(id);
        return ApiResult.ok();
    }

    @PostMapping("/buTreeNode/buTreeNodeAddEmployee")
    @ApiOperation("组织树节点添加员工关系-重复不添加")
    public ApiResult<String> buTreeNodeAddEmployee(@Valid @RequestBody BuTreeNodeEmployeeParam param) {
        return orgBuTreeDService.buTreeNodeAddEmployee(param);
    }

    @PostMapping("/buTreeNode/buTreeNodeSaveEmployee")
    @ApiOperation("组织树节点保存员工关系-全删全插")
    public ApiResult<String> buTreeNodeSaveEmployee(@Valid @RequestBody BuTreeNodeEmployeeParam param) {
        return orgBuTreeDService.buTreeNodeSaveEmployee(param);
    }

    @DeleteMapping("/buTreeNode/buTreeNodeDeleteEmployee")
    @ApiOperation("组织树节点删除员工关系")
    public ApiResult<String> buTreeNodeDeleteEmployee(@Valid @RequestBody BuTreeNodeDeleteEmployeeParam param) {
        return orgBuTreeDService.buTreeNodeDeleteEmployee(param);
    }

    @PostMapping("/buTreeNode/buTreeNodeQueryEmployee")
    @ApiOperation("查询组织树节点员工关系")
    public ApiResult<List<EmployeePagedRespVO>> buTreeNodeQueryEmployee(@RequestBody BuTreeNodeQueryEmployeeParam param) {
        return orgBuTreeDService.buTreeNodeQueryEmployee(param);
    }
}
