package com.elitescloud.cloudt.system.modules.orgtree.model;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/17
 */
@Data
@ApiModel(description = "组织树树形结构明细反参")
public class OrgBuTreeDDetailDTO implements Serializable {

    private static final long serialVersionUID = 7191591246144372541L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("组织树明细id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树ID")
    private Long buTreeId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "BU组织ID")
    private Long buId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;
}
