package com.elitescloud.cloudt.system.modules.orgtree.model;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/16
 */
@Data
@ApiModel(description = "组织树组织明细")
public class OrgBuTreedAllDTO implements Serializable {

    private static final long serialVersionUID = 5011508119035375452L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "组织树明细id")
    private Long id;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    private String buCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("BU组织id")
    private Long buId;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称")
    private String buName;

    /**
     * 组织简称
     */
    @ApiModelProperty(value = "组织简称")
    private String buAbbr;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty(value = "组织类型 [UDC]ORG:BU_TYPE")
//    @SysCode(sys = "yst-supp", mod = "BU_TYPE")
    private String buType;
    private String buTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty(value = "组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "yst-supp", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;
}
