package com.elitescloud.cloudt.system.modules.orgtree.service;

import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.SystemBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVDSaveParam;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2020/7/2
 */
public interface OrgBuTreeVersionDomainService {
    /**
     * 根据组织树编码获取系统域生效的版本号 如果系统域没有配置则以最新生效的版本  如果系统域已经配置 以系统域配置的版本为准
     * 影响的页面：商品经营目录组织树，商品冻结选择冻结范围，数据权限，同步激荡云
     * 不影响：员工页面的所有组织树选项（全部以生效的为准），组织树履历展现当前的生效的组织也不受此影响
     *
     * @param systemCode 系统参数  (请在系统中心-系统设置 中查询)
     * @return 版本数据
     */
    SystemBuTreeDTO findActiveVersionByBuTreeCode(String systemCode);


    /**
     * 保存组织树版本节点信息
     *
     * @param params     节点信息
     * @param buTreeId   组织树id
     * @param updateFlag 是否为更新操作
     */
    void saveBuTreeDV(List<OrgBuTreeVDSaveParam> params, Long buTreeId, Boolean updateFlag);


    /**
     * 获取节点信息（节点缓存）
     *
     * @param buTreeId   组织树id
     * @param searchType 类型
     * @param buTreeDId  节点id
     * @return
     */
    List<OrgBuTreeDDTO> getOrgBuTreeDByCache(Long buTreeId, String searchType, Long buTreeDId);

    /**
     * 获取节点信息（节点缓存）
     *
     * @param buTreeId   组织树id
     * @param searchType 类型
     * @param buTreeDId  节点id
     * @return
     */
    List<OrgBuTreeDDTO> getOrgBuTreeDFromSystem(Long buTreeId, String searchType, Long buTreeDId);
}
